﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;
using System.Text;
using System.Xml;
using System.Net.Mail;
using Gemini.Core.WebApplication.Base;
using System.Net;
using PI.ZB.N1200.ELearning.BL.APIMobile.Model;
using Gemini.Core.BL.Interface;

namespace PI.ZB.N1200.ELearning.WebApplication.API
{
    public partial class ELearning : Gemini.Core.WebApplication.Base.APIComponent
    {
        public abstract class BaseAPIMethod
        {
            /// <summary>
            /// Status odpowiedzi
            /// </summary>
            public enum StatusCodeType
            {
                OK = 200,
                BadRequest = 400,
                Unauthorized = 401,
                Forbidden = 403,
                NotFound = 404,
                NotAcceptable = 426,
                InternalServerError = 500,
            }

            public BaseAPIMethod(ELearning Component)
            {
                this.Component = Component;
                StatusCode = StatusCodeType.BadRequest;
            }

            /// <summary>
            /// Nazwa metody API
            /// </summary>
            public abstract string Name { get; }

            /// <summary>
            /// Komponent ELearning
            /// </summary>
            protected ELearning Component { get; private set; }           
           
            /// <summary>
            /// U.ywane kody HTTP (wspolne dla ka.dej metody):
            /// OK             -   200 - OK (tre.. odpowiedzi zawiera ..dane informacje),
            /// BadRequest     -   400 - b..dne ..danie (np. proba zalogowania si. bez podania nazwy u.ytkownika)
            /// Unauthorized   -   401 - brak autoryzacji (nie zalogowano), nale.y ponowi. logowanie
            /// Forbidden      -   403 - brak dost.pu (zalogowano przez API, jednak uprawnienia s. niewystarczaj.ce),
            /// NotFound       -   404 - nie znaleziono obiektu, o ktory wys.ano zapytanie,
            /// NotAcceptable  -   426 - klucz API wygas., nale.y pobra. now. wersj. aplikacji
            /// InternalServerError - 500 - API eduKariera jest tymczasowo niedost.pne.
            /// </summary>
            protected internal StatusCodeType StatusCode { get; set; }

            /// <summary>
            /// Odpowiedz, moze byc NULL, ale wowczas trzeba wypelnic odpowiednie
            /// komunikaty bledow
            /// </summary>
            protected internal GResponseData ResponseData { get; private set; }

            /// <summary>
            /// Metoda służy do zaczytania do zmiennych lokalnych wszystkich
            /// parametrów które przychodzą w żądaniu
            /// </summary>
            protected abstract void DoReadRequestParams();

            /// <summary>
            /// Metoda służąca do walidacji poszczególnych typów requestów
            /// Po zaczytaniu parametrów należy je tutaj zwalidować
            /// i w razie potrzeby ustawić komunikaty błędów oraz włąściwy StatusCode
            /// </summary>
            /// <returns></returns>
            protected abstract bool DoValidate();

            /// <summary>
            /// Metoda służy do stworzenia całego obiektu odpowiedzialnego
            /// za dane jako Reponse. Może zwracać NULL,
            /// ale wóczas musi też ustawić właściwe komunikaty błędów
            /// oraz StatusCode
            /// </summary>
            /// <returns></returns>
            protected abstract GResponseData DoGetGResponseData();

            /// <summary>
            /// Metoda służąca do walidacji danych pochodzących z parametrów QueryString (GET)
            /// albo Formy (POST).
            /// Na początku sprawdzane jest czy jest wazna sesja, a potem
            /// dokonuje walidacji danych DoValidate()
            /// </summary>
            /// <returns></returns>
            protected virtual bool IsValid()
            {
                return IsSessionValid() && DoValidate();
            }

            /// <summary>
            /// Metoda do przetwarzania całego requesta
            /// Jeżeli całe przetwarzanie zakończy sie pomyślnie oraz ResponseData nie jest NULL to zwraca TRUE
            /// Jeżeli przetwarzanie nie może sie powieść, wóczas FALSE
            /// i trzeba ustaić włąściwy StatusCode oraz
            /// dodać właściwe błędy
            /// </summary>
            /// <returns></returns>
            protected bool ProcessRequest()
            {
                DoReadRequestParams();
                if (IsValid())
                {
                    ResponseData = DoGetGResponseData();
                    return ResponseData != null;
                }
                return false;
            }

            /// <summary>
            /// Metoda wykorzystywana przez flow API
            /// do wysłania całej odpowiedzi do klienta
            /// </summary>
            /// <returns></returns>
            public string GetResponseString()
            {
                if (ProcessRequest())
                {
                    return GResponse.ToJson(ResponseData);
                }
                return String.Join("\r", _errorMessages.ToArray());
            }

            private List<string> _errorMessages = new List<string>();
            /// <summary>
            /// Dodaje komunikat błędu w przypadku walidacji
            /// </summary>
            /// <param name="Value"></param>
            /// <param name="p"></param>
            protected void AddErrorMessage(string Value, params object[] p)
            {
                _errorMessages.Add(string.Format(Value, p));
            }


            private ISession _Session = null;
            /// <summary>
            /// Sesja ustawiona za pomoca metody IsSessionValid
            /// </summary>
            protected ISession Session 
            {
                get
                {
                    if (_Session == null)
                    {
                        IsSessionValid();
                    }                    
                    return _Session;
                }
            }

            /// <summary>
            /// Sprawdza czy sesja jst wazna i ustawia odpowiedni StatusCode jezeli sesja nie jest juz wazna.
            /// </summary>
            /// <param name="Session"></param>
            /// <returns></returns>
            protected bool IsSessionValid()
            {
                if (_Session != null)
                {
                    return true;
                }

                string _session_id = Component.APIRequestParams["session_id"];
                if (!string.IsNullOrEmpty(_session_id) && Component.Environment.SessionManager != null)
                {
                    _Session = Component.Environment.SessionManager.Get(_session_id);
                    if (_Session != null)
                    {
                        // w przypadku API nie sprawdzamy ClientName - czyli jedna sesja moze byc
                        // wspoldzielona przez wiele urzadzen/przegladarek majac jej UID
                        // (oraz na przegladarce trzeba wymusic wowczas parametr: g_donotcheckclientname)
                        _Session.CheckClientName = false;
                    }
                    if (_Session != null && Component.Environment.SessionManager.IsValid(_Session))
                    {
                        Component.Environment.SessionManager.UpdateActivity(Session);

                        _User = Component.BLELearning.RBL.Account.User.View.Restore(_Session.UserID);

                        return Component.Environment.Login(_User.Login, _User.Password);
                    }
                    AddErrorMessage("Sesja straciła ważność. Należy zalogować sie ponownie.");
                    StatusCode = StatusCodeType.Unauthorized;
                }
                else
                {
                    AddErrorMessage("Podano niepoprawny identyfikator sesji.");
                }
                return false;
            }

            private PI.FM.N001.Account.BL.BO.View.User _User = null;
            /// <summary>
            /// Użytkownik odczytany z sesji
            /// </summary>
            protected PI.FM.N001.Account.BL.BO.View.User User
            {
                get
                {
                    if (_User != null)
                    {
                        return _User;
                    }

                    if (Session != null && _User == null)
                    {
                        _User = Component.BLELearning.RBL.Account.User.View.Restore(this.Session.UserID);
                    }
                    return _User;
                }
            }
            
        }
    }
}